/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleEvent;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleListener;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ManagedErrorIds;
import com.ibm.hwmca.fw.managed.ProductEngineeringUser;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimerTask;

public class UpdateLinuxPasswd
implements TimeChangedOnConsoleListener,
Runnable,
ManagedErrorIds {
    public static final FrameworkClassLogInfo LOGINFO = new FrameworkClassLogInfo(85, "UpdateRootPw");
    private static final String TRACE_MASKT = "XPWUPDRT";
    private static final String TRACE_MASKF = "XPWUPDRF";
    private static final String TRACE_MASKD = "XPWUPDRD";
    private static final String SET_ROOT_PASSWORD_PROGRAM = "callpasswd";
    private static NamedTimer passwordChangeTimer = new NamedTimer(true, "Root password change thread");
    private static PasswordChangeTimerTask passwordChangeTimerTask = new PasswordChangeTimerTask();
    private static boolean timerScheduled = false;
    private static long MILLISECONDS_IN_A_DAY = 86400000L;

    public void run() {
        Trace.trace(TRACE_MASKT, "-> run()");
        if (!System.getProperty("DEVELOPMENT_SYSTEM", "no").equalsIgnoreCase("yes")) {
            TimeManager.getTimeManager().addTimeChangedOnConsoleListener(this);
            try {
                this.setupTimer();
                UpdateLinuxPasswd.setRootPassword();
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKF, "An error occurred while setting up the timer or setting the root user's password");
            }
        }
        Trace.trace(TRACE_MASKT, "<- run()");
    }

    public void timeChangedOnConsole(TimeChangedOnConsoleEvent event) {
        Trace.trace(TRACE_MASKT, "-> timeChangedOnConsole()");
        GregorianCalendar oldDate = new GregorianCalendar();
        oldDate.setTime(event.getOldTime());
        GregorianCalendar newDate = new GregorianCalendar();
        newDate.setTime(event.getNewTime());
        if (oldDate.get(6) - newDate.get(6) != 0) {
            Trace.trace(TRACE_MASKF, "difference Day of Year difference: " + (oldDate.get(6) - newDate.get(6)));
            Trace.trace(TRACE_MASKF, "olddate = " + oldDate.getTime().toString());
            Trace.trace(TRACE_MASKF, "newdate = " + newDate.getTime().toString());
            try {
                UpdateLinuxPasswd.setRootPassword();
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKF, "An error occurred while setting the root user's password");
            }
        }
        try {
            this.setupTimer();
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "An error occurred while setting the timer");
        }
        Trace.trace(TRACE_MASKT, "<- timeChangedOnConsole()");
    }

    private synchronized void setupTimer() throws HException {
        Trace.trace(TRACE_MASKT, "-> setupTimer()");
        if (timerScheduled) {
            Trace.trace(TRACE_MASKF, "About to cancel existing timer");
            passwordChangeTimerTask.cancel();
            timerScheduled = false;
        }
        Calendar cal = Calendar.getInstance();
        Trace.trace(TRACE_MASKF, "Current date/time=" + cal.getTime());
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 1);
        cal.set(13, 0);
        Trace.trace(TRACE_MASKF, "About to schedule a timer for every 24 hours beginning at " + cal.getTime());
        try {
            passwordChangeTimerTask = new PasswordChangeTimerTask();
            passwordChangeTimer.scheduleAtFixedRate((TimerTask)passwordChangeTimerTask, cal.getTime(), MILLISECONDS_IN_A_DAY);
            timerScheduled = true;
        }
        catch (IllegalStateException ise) {
            HException he = new HException("Attempt to set timer for nightly root password change failed: " + ise);
            new FrameworkLog(LOGINFO, 2467, he).log();
            throw he;
        }
        Trace.trace(TRACE_MASKT, "<- setupTimer()");
    }

    private static void setRootPassword() throws HException {
        Trace.trace(TRACE_MASKT, "-> setRootPassword()");
        String password = ProductEngineeringUser.getProductEngineeringUser().getPasswordNotEncrypted();
        Trace.trace(TRACE_MASKD, "PEMODE password = " + password);
        String cmd = "callpasswd " + password;
        try {
            int rc = RootProcess.executeProgram(cmd);
            Trace.trace(TRACE_MASKF, "callpasswd completed with rc=" + rc);
            if (rc != 0) {
                HException he = new HException("Attempt to set root password failed with rc=" + rc);
                new FrameworkLog(LOGINFO, 2466, he).log();
                throw he;
            }
            new SystemEventLog(new FrameworkEventText(864), "ROOTPWUPD").log();
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "IOException while attempting to run command: \"callpasswd\"");
            HException he = new HException(ioe);
            new FrameworkLog(LOGINFO, 2466, he).log();
            throw he;
        }
        Trace.trace(TRACE_MASKT, "<- setRootPassword()");
    }

    private static class PasswordChangeTimerTask
    extends TimerTask {
        private PasswordChangeTimerTask() {
        }

        public void run() {
            Trace.trace(UpdateLinuxPasswd.TRACE_MASKT, "-> PasswordChangeTimerTask.run()");
            try {
                UpdateLinuxPasswd.setRootPassword();
            }
            catch (HException he) {
                Trace.trace(UpdateLinuxPasswd.TRACE_MASKF, "An error occurred while setting the root user's password");
            }
            Trace.trace(UpdateLinuxPasswd.TRACE_MASKT, "<- PasswordChangeTimerTask.run()");
        }
    }
}

